#
# confnetinf.sh	Configuration network interfaces
#

if [ -x /usr/local/bin/get_nvconf ]
then
	nvipaddr=`/usr/local/bin/get_nvconf e`
	nvnetmask=`/usr/local/bin/get_nvconf n`
	nvgateway=`/usr/local/bin/get_nvconf g`
else
	echo "/usr/local/bin/get_nvconf not found"
	exit
fi

name=
nvnetwork=
nvbroadcast=
echo "Configuration network interfaces"
count=1
while [ $count -lt 5 ]
do
	ip=`echo $nvipaddr | cut -d "." -f $count`
	msk=`echo $nvnetmask | cut -d "." -f $count`
	net=$((ip&msk))
	brd=$((net|(~msk&255)))
	nvnetwork=$nvnetwork$net
	nvbroadcast=$nvbroadcast$brd
	if [ $count -ne 4 ]
	then
		nvnetwork=$nvnetwork.
		nvbroadcast=$nvbroadcast.
	fi
	name=$name$ip
	count=`expr $count + 1`
done

# ========================================
# config  /etc/sysconfig/network-scripts/ifcfg-eth0
#
CONFIG_FILE=/etc/sysconfig/network-scripts/ifcfg-eth0

if [ -e $CONFIG_FILE ]
then
	cfgipaddr=`grep ^IPADDR $CONFIG_FILE | cut -d "=" -f 2`
	cfgnetmask=`grep ^NETMASK $CONFIG_FILE | cut -d "=" -f 2`
	cfgnetwork=`grep ^NETWORK $CONFIG_FILE | cut -d "=" -f 2`
	cfgbroadcast=`grep ^BROADCAST $CONFIG_FILE | cut -d "=" -f 2`

	cp $CONFIG_FILE /var/tmp/interfaces.0

	if [ "$cfgipaddr" != "$nvipaddr" ]
	then
		sed -e s/^IPADDR=.*/IPADDR=$nvipaddr/ /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi

	if [ "$cfgnetmask" != "$nvnetmask" ]
	then
		sed -e s/^NETMASK=.*/NETMASK=$nvnetmask/ /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi

	if [ "$cfgnetwork" != "$nvnetwork" ]
	then
		sed -e s/^NETWORK=.*/NETWORK=$nvnetwork/ /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi

	if [ "$cfgbroadcast" != "$nvbroadcast" ]
	then
		sed -e s/^BROADCAST=.*/BROADCAST=$nvbroadcast/ /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi

	mv /var/tmp/interfaces.0 $CONFIG_FILE
fi


# ========================================
# config  /etc/sysconfig/network
#
CONFIG_FILE=/etc/sysconfig/network

if [ -e $CONFIG_FILE ]
then
	cfggateway=`grep ^GATEWAY $CONFIG_FILE | cut -d "=" -f 2`

	sed -e s/^DEFAULTHOSTNAME=.*/DEFAULTHOSTNAME=bizhub_$name/ $CONFIG_FILE > /var/tmp/network.tmp
	mv /var/tmp/network.tmp $CONFIG_FILE

	if [ "$cfggateway" != "$nvgateway" ]
	then
		sed -e s/^GATEWAY=.*/GATEWAY=$nvgateway/ $CONFIG_FILE > /var/tmp/network.tmp
		mv /var/tmp/network.tmp $CONFIG_FILE
	fi
fi

# ========================================
# config  /etc/network/interfaces
#
CONFIG_FILE=/etc/network/interfaces

if [ -e $CONFIG_FILE ]
then
	cfgipaddr=`grep ^address $CONFIG_FILE | cut -d " " -f 2`
	cfgnetmask=`grep ^netmask $CONFIG_FILE | cut -d " " -f 2`
	cfggateway=`grep ^gateway $CONFIG_FILE | cut -d " " -f 2`
	cfgbroadcast=`grep ^broadcast $CONFIG_FILE | cut -d " " -f 2`

	cp $CONFIG_FILE /var/tmp/interfaces.0

	if [ "$cfgipaddr" != "$nvipaddr" ]
	then
		sed -e "s/^address .*/address $nvipaddr/" /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi

	if [ "$cfgnetmask" != "$nvnetmask" ]
	then
	    	sed -e "s/^netmask .*/netmask $nvnetmask/" /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi

	if [ "$cfgbroadcast" != "$nvbroadcast" ]
	then
	    sed -e "s/^broadcast .*/broadcast $nvbroadcast/" /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi

	if [ "$cfggateway" != "$nvgateway" ]
	then
		sed -e "s/^gateway .*/gateway $nvgateway/" /var/tmp/interfaces.0 > /var/tmp/interfaces.tmp
		mv /var/tmp/interfaces.tmp /var/tmp/interfaces.0
	fi
	mv /var/tmp/interfaces.0 $CONFIG_FILE
fi
