#!/bin/sh

# Copyright (c) 2016-2017 Konica Minolta Laboratory USA, Inc
# San Mateo, CA, USA      All Rights Reserved.
#
# modification history (latest on top)
# --------------------
# 05jun17,spn   added error detection
# 03may17,thien added handling for memnet heartbeat
# 25aug16,spn   created

STATUS=0

# End of LCM is 0xd0ffffff
SUSPEND_ADDR="0xd0ffffe0"
RESUME_ADDR="0xd0fffff0"

do_error () {
        echo $1
        STATUS=1
}

# Initialize the suspend areas to zero
suspendAreaInit () {
        devmem 0xd0ffffe0 32 0 || do_error "devmem failed"
        devmem 0xd0ffffe4 32 0 || do_error "devmem failed"
        devmem 0xd0ffffe8 32 0 || do_error "devmem failed"
        devmem 0xd0ffffec 32 0 || do_error "devmem failed"
}

echo -n "Send suspend request to memnet heartbeat..."
pid=$(pidof heartbeat)

if [ $? -ne 0 ]; then
	do_error "failed."
else
	kill -s SIGUSR2 $pid

	if [ $? -ne 0 ]; then
		do_error "failed."
	else
		echo "done."
	fi
fi

echo -n "Send suspend request to engine side..."
/tools/lxNvProxyClient 2; ret=$?
if [ $ret -ne 0 ]; then
	do_error "failed with ret = $ret"
else
	echo "done."
fi

echo -n "Wait for engine to acknowledge suspend..."
i=0;
#last=2;
last=10; #new timing
while [ true ]; do
	val=$(devmem $SUSPEND_ADDR 8)

	if [ $? -ne 0 ]; then
		do_error "devmem failed"
		break
	elif [ "$val" != "0x00" ]; then
		break
	fi

	i=$(expr $i + 1)

	if [ $i -lt $last ]; then
		sleep 1
		echo -n "."
	else
		do_error "timeout detected!"
		break
	fi
done
echo "done."

echo -n "Reinitialize suspend area..."
suspendAreaInit
echo "done."

exit $STATUS
